import pandas as pd  
import pickle 
from decision_company import read_csv_file, check_elements_in_list, fetch_column
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Filter the dataset based on the specified criteria  
good_credit_history = check_elements_in_list(fetch_column(credit_customers, 'credit_history'), ['existing paid', 'all paid'])  
age_group = (fetch_column(credit_customers, 'age') >= 25) & (fetch_column(credit_customers, 'age') <= 45)  
stable_employment = check_elements_in_list(fetch_column(credit_customers, 'employment'), ['>=7', '4<=X<7'])  
  
# Combine the filters and apply them to the dataset  
target_customers = credit_customers[good_credit_history & age_group & stable_employment] 

print("target_customers:\n", target_customers)    
pickle.dump(target_customers,open("./ref_result/target_customers.pkl","wb"))